package ch.sahits.game.openpatrician.model.map;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.IWare;

import java.util.Set;

/**
 * This interface defines a stop on a {@link ITradeRoute}. Each stop is
 * associated with a {@link ch.sahits.game.openpatrician.model.city.ICity} and
 * a set of {@link ch.sahits.game.openpatrician.model.product.IWare}s that should be bought
 * at that stop.
 */
public interface ITradeRouteStop {
    /**
     * Which city is represented by this trade stop.
     * @return city of the trade stop
     */
    ICity getTradeStop();

    /**
     * Retrieve the wares that should be bought at this trade stop.
     * @return set of wares to buy
     */
    Set<IWare> getWaresToBuy();
}
