package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.city.ICity;

import java.time.LocalDateTime;


public interface IFugitive extends ISideRoomPerson {

	/**
	 * Get the destination city for the traveler.
	 * @return destination city of the fugative
	 */
	ICity getDestination();
	/**
	 * Retrieve the premium promised upon delivery.
	 * @return premium for successful delivery of the fugative.
	 */
	int getPremium();
	/**
	 * Date at which the traveler must arrive at the destination.
	 * @return
	 */
	LocalDateTime getArrivalAtDestinationDate();

}
