package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.product.IWare;
/**
 * Interface defining a person that trades ware.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 23, 2013
 *
 */
public interface ITradePerson extends IPerson{

	/**
	 * The ware the broker is to be delivered.
	 * @return ware the trader whiches to aquire.
	 */
	IWare getWare();

	/**
	 * Amount of the ware that is to be delivered.
	 * The amount is in the ware specific quantity.
	 * @return amount of the ware
	 */
	int getAmount();

	/**
	 * Get the price of a single item
	 * @return average price per item.
	 */
	int getAvgPricePerItem();

	/**
	 * Set the ware for the trade.
	 * @param ware of the trade
	 */
	void setWare(IWare ware);

	/**
	 * Set the amount of the trade
	 * @param amount of the ware to be traded
	 */
	void setAmount(int amount);

	/**
	 * Set the price per item
	 * @param avgPricePerItem average price per item of the ware.
	 */
	void setAvgPricePerItem(int avgPricePerItem);
}