package ch.sahits.game.openpatrician.model.people;

/**
 * The owner of a treasure map offers you a part of it to be sold.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface ITreasureMapOwner extends ISideRoomPerson {
	/**
	 * Name of the owner
	 * @return of the map owner.
	 */
	String getName();
	/**
	 * Retrieve the price of the treasure map.
	 * @return for the map segment
	 */
	int getPrice();

	/**
	 * Set the name of the map owner
	 * @param name of map owner
	 */
	void setName(String name);

	/**
	 * Set the price for a map segment
	 * @param price for the map segment.
	 */
	void setPrice(int price);
}
