package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IBaseTraveler;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

/**
 * Base implementation of a person that needs to travel from one location to another.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 26, 2013
 */
abstract class BaseTravelerState extends BaseTavernPerson implements IBaseTraveler {

	@Getter
	@Setter
    private ICity destination;
    @Getter
	@Setter
	private int premium;
    @Getter
	@Setter
	private LocalDateTime arrivalAtDestinationDate;

	@Override
	public int getMaxDaysPresent() {
		int maxDays = super.getMaxDaysPresent();
		if (getArrivalAtDestinationDate() != null) {
			long deltaDays = ChronoUnit.DAYS.between(date.getCurrentDate(), getArrivalAtDestinationDate());
			if (deltaDays <= 0) {
				return 0;
			}
			return Math.min(maxDays, (int) deltaDays);
		} else {
			return maxDays;
		}
	}
}