package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.AUpdatableCityRelated;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * Implementation of a trader. Every city can have a trader and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatableCityRelated
public class TraderState extends BaseTavernPerson implements ITrader {
	@Autowired
    @Qualifier("baseTradePerson")
	@Getter
	private BaseTradePerson tradePerson;

	@Override
	public IWare getWare() {
		return tradePerson.getWare();
	}

	@Override
	public void setWare(IWare ware) {
		tradePerson.setWare(ware);
	}

	@Override
	public int getAmount() {
		return tradePerson.getAmount();
	}

	@Override
	public int getAvgPricePerItem() {
		return tradePerson.getAvgPricePerItem();
	}

	@Override
	public void setAmount(int amount) {
		tradePerson.setAmount(amount);
	}

	@Override
	public void setAvgPricePerItem(int avgPricePerItem) {
		tradePerson.setAvgPricePerItem(avgPricePerItem);
	}

}
