package ch.sahits.game.openpatrician.model.personal;


/**
 * Indicating the reputation of a player in a city. This is updated on a weekly basis
 * The reputation is periodically updated.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
public interface IReputation {
	/**
	 * Retrieve the change in reputation within the last week.
	 * Single digit values indicate a small change, values larger than
	 * 25 indicate a very large change. 
	 * @return reputation change in the last week
	 */
	int getReputationDifference();
	/**
	 * Retrieve the popularity of the player in the city
	 * @return current popularity in the city this instance is assigned to
	 */
	int getPopularity();

    /**
     * Update the reputation by the amount.
     * @param amount new reputation amount.
     */
     void update(int amount);

	/**
	 * Update the reputation with the reputation change by supplying wares.
	 * @param wareReputation reputation bonus by ware delivery.
     */
	void addWareReputation(int wareReputation);
}
