package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.product.IWare;

/**
 * Production and consumption knowledge of a specific city.
 */
public interface ICityProductionConsumptionKnowledge {

    /**
     * Retrieve the consumption amount for a ware.
     * @param ware for which the production amount is to be looked up
     * @return amount produced in the city per week.
     */
    int getProductionAmount(IWare ware);
    /**
     * Retrieve the consumption amount for a ware.
     * @param ware for which the consumption amount is to be looked up.
     * @return amount consumed in the city per week
     */
    int getConsumptionAmount(IWare ware);
    /**
     * Retrieve the stored amount for a ware.
     * @param ware for which the stored amount is to be looked up.
     * @return stored amount.
     */
    int getStoredAmount(IWare ware);
}
