package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.model.ship.INavigableVessel;

import java.util.Iterator;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 01, 2016
 */
public interface ITravellingVessels extends Iterable<INavigableVessel> {
    @Override
    Iterator<INavigableVessel> iterator();

    /**
     * Retrieve the meta date for a travelling vessel.
     * @param vessel for which to get the travelling instance
     * @return TravellingVessel instance for <code>vessel</code>
     */
    TravellingVessel getTravellingVessel(INavigableVessel vessel);

    /**
     * Check if the vessel is currently travelling.
     * @param vessel to be checked if it is travelling
     * @return true if there is an instance of {@link TravellingVessel} for <code>vessel</code>
     */
    boolean isTravelling(INavigableVessel vessel);
}
