package ch.sahits.game.openpatrician.model.sea.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.MultimapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 14, 2016
 */
@Prototype
@ClassCategory({EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class Blockade implements IBlockade {
    @Autowired
    private PlayerList players;

    @Getter
    private final LocalDateTime assemblyDate;
    @Getter
    private final LocalDateTime endBlockade;
    @MapType(key = String.class, value = Integer.class)
    private Map<String, Integer> requestedShips = new HashMap<>();
    @MultimapType(key = IPlayer.class, value=IShip.class)
    private Multimap<IPlayer, IShip> ships = ArrayListMultimap.create();
    @Getter
    @ListType(IShip.class)
    private List<IShip> shipsToAuction = new ArrayList<>();
    @Setter
    private IConvoy convoy;

    public Blockade(LocalDateTime assemblyDate, LocalDateTime endBlockade) {
        this.assemblyDate = assemblyDate;
        this.endBlockade = endBlockade;
    }

    @Override
    public IConvoy getBlockadeConvoy() {
        return convoy;
    }

    @Override
    public List<IShip> getShips(IPlayer player) {
        return new ArrayList<>(ships.get(player));
    }

    public List<IShip> getShips() {
       return new ArrayList<>(ships.values());
    }
    
    public void requestShip(IPlayer player, int number) {
        requestedShips.put(player.getUuid(), number);
    }

    public int getNumberOfRequestedShips(IPlayer player) {
        return requestedShips.get(player.getUuid());
    }
    public List<IPlayer> getPlayersWithRequestedShips() {
        return players.stream()
                .filter(player -> requestedShips.containsKey(player.getUuid()))
                .collect(Collectors.toList());
    }
    public void addShips(IPlayer player, List<IShip> shipList) {
        ships.putAll(player, shipList);
    }
    

    

    
    
}
