package ch.sahits.game.openpatrician.model.service.persistance.converter;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import javafx.geometry.Dimension2D;

/**
 * Converter for Dimension2D.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Nov 25, 2018
 */
@ClassCategory(EClassCategory.STARTUP)
public class Dimension2DConverter implements Converter {
    @Override
    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
       Dimension2D dim = (Dimension2D) o;
       hierarchicalStreamWriter.addAttribute("w", String.valueOf(dim.getWidth()));
       hierarchicalStreamWriter.addAttribute("h", String.valueOf(dim.getHeight()));
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        return new Dimension2D(Double.parseDouble(hierarchicalStreamReader.getAttribute("w")),
                Double.parseDouble(hierarchicalStreamReader.getAttribute("h")));
    }

    @Override
    public boolean canConvert(Class aClass) {
        return Dimension2D.class.equals(aClass);
    }
}
