package ch.sahits.game.openpatrician.model.service.persistance.converter;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import javafx.beans.binding.ObjectBinding;
import lombok.extern.slf4j.Slf4j;

/**
 * Converter for ObjectBindings.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Nov 25, 2018
 */
@Slf4j
@ClassCategory(EClassCategory.STARTUP)
public class ObjectBindingsConverter implements Converter {
    @Override
    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
            String className = o.getClass().getName();
            hierarchicalStreamWriter.addAttribute("class-name", className);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String className = hierarchicalStreamReader.getAttribute("class-name");
        try {
            Class clazz = Class.forName(className);
            return clazz.newInstance();
        } catch (IllegalAccessException|InstantiationException|ClassNotFoundException e) {
            log.warn("Failed to create Object binding for class {}, {}", className, e.getMessage());
        }
        return null;
    }

    @Override
    public boolean canConvert(Class aClass) {
        return ObjectBinding.class.isAssignableFrom(aClass);
    }
}
