package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * Property class for the ships properties.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Aug 15, 2017
 */
@Component
@PropertySource("classpath:application.properties")
@ConfigurationProperties(prefix = "ship")
@Getter
@Setter
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ShipProperties {

    private Ship crayer = new Ship();
    private Ship cog = new Ship();
    private Ship holk = new Ship();
    private Ship snaikka = new Ship();

    @Getter
    @Setter
    public static class Ship {
        private int initialValue;
        private int minNumberOfSailors;
        private int maxSailors;
        private int size;
        private int reductionLevel1;
        private int reductionLevel2;
        private double speedkmperh;
        private int distanceInKmForOneHealthPointReduction;
        private Capacity capacity = new Capacity();
    }
    @Getter
    @Setter
    public static class Capacity {
        private int min;
        private int max;
    }
}
