package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.ShipProperties;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;


/**
 * This model represents a crayer.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 19, 2011
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Crayer extends Ship implements ICrayer {
	@Autowired
	@XStreamOmitField
	private ShipProperties shipProperties;
	@Autowired
	@XStreamOmitField
	private ShipWeaponsLocationFactory weaponsLocationFactory;
	/**
	 * Constructor initializing the name and the upgrade level
	 * @param upgradeLevel upgrade level of the crayer
	 * @param name ships name
	 */
	public Crayer(EShipUpgrade upgradeLevel, String name) {
		this.shipUpgradeLevel = upgradeLevel;
		this.name = name;
	}
	/**
	 * Constructor for a Crayer without any upgrade
	 * @param name ships name
	 */
	public Crayer(String name) {
		this(EShipUpgrade.NONE,name);
	}

	@PostConstruct
	private void init() {
		super.initializeProperties(shipProperties.getCrayer());
		setWeaponSlots(weaponsLocationFactory.getShipWeaponsLocation(EShipType.CRAYER, shipUpgradeLevel));
	}

	@Override
	public EShipType getShipType() {
		return EShipType.CRAYER;
	}

}
