package ch.sahits.game.openpatrician.model.ui;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import lombok.Builder;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jan 01, 2015
 */
@RequiredArgsConstructor
@Builder
@ClassCategory({EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class DialogTemplate {
    @Getter
    private final String titleKey;
    @Getter
    private final String messageKey;
    @Getter
    private final Object[] messageArgs;
    @Getter
    @ListType(ButtonTemplate.class)
    private final List<ButtonTemplate> buttons;
    @Getter
    private final boolean closable;

    @Override
    public String toString() {
        return "DialogTemplate{" +
                "titleKey='" + titleKey + '\'' +
                ", messageKey='" + messageKey + '\'' +
                '}';
    }
}
