package ch.sahits.game.openpatrician.model.weapon;

import ch.sahits.game.openpatrician.model.product.BezierPriceCurve;
import ch.sahits.game.openpatrician.model.product.IBezierPriceCurve;
import ch.sahits.game.openpatrician.utilities.service.PropertyLoader;
import com.google.common.base.Preconditions;
import javafx.geometry.Point2D;
import lombok.Getter;

import java.util.Properties;

/**
 * Enumeration defining all weapons
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 23, 2011
 *
 */
public enum EWeapon implements IWeapon {
	SWORD("sword.properties"),
	BOW("bow.properties"),
	CROSSBOW("crossbow.properties"),
	MUSKET("musket.properties"),
	BALLISTA_SMALL("ballista_small.properties"),
	TREBUCHET_SMALL("trebuchet_small.properties"),
	BALLISTA_BIG("ballista_big.properties"),
	TREBUCHET_BIG("trebuchet_big.properties"),
	BOMBARD("bombard.properties"),
	CANNON("cannon.properties"),
	HAND_WEAPON("hand_weapon.properties");
//	private final Locale locale = Locale.getInstance();
	@Getter
	private final int maxValueBuy;
	@Getter
	private final int minValueBuy;
	@Getter
	private final int maxValueSell;
	@Getter
	private final int minValueSell;
	@Getter
	private final int marketSaturationForSelling;
	@Getter
	private final int marketSaturationForBuying;
	@Getter
	private final double strength;
	@Getter
	private final double size;
	@Getter
	private final double damage;
	@Getter
	private final double kill;
	@Getter
	private final int range;
	@Getter
	private final IBezierPriceCurve buyCurve;
	@Getter
	private final IBezierPriceCurve sellCurve;

    EWeapon(String configFileName) {
		Properties props = PropertyLoader.loadProperties(configFileName);
		Preconditions.checkNotNull(props.getProperty("maxValueBuy"), "The property file "+configFileName+" does not contain the maxValueBuy property");
		Preconditions.checkNotNull(props.getProperty("minValueBuy"), "The property file "+configFileName+" does not contain the minValueBuy property");
		Preconditions.checkNotNull(props.getProperty("maxValueSell"), "The property file "+configFileName+" does not contain the maxValueSell property");
		Preconditions.checkNotNull(props.getProperty("minValueSell"), "The property file "+configFileName+" does not contain the minValueSell property");
		Preconditions.checkNotNull(props.getProperty("saturation"), "The property file "+configFileName+" does not contain the saturation property");
		maxValueBuy=Integer.parseInt(props.getProperty("maxValueBuy"));
		minValueBuy=Integer.parseInt(props.getProperty("minValueBuy"));
		marketSaturationForSelling=Integer.parseInt(props.getProperty("saturation"));
		marketSaturationForBuying=Integer.parseInt(props.getProperty("saturation"));
		minValueSell=Integer.parseInt(props.getProperty("minValueSell"));
		maxValueSell=Integer.parseInt(props.getProperty("maxValueSell"));
		strength=Double.parseDouble(props.getProperty("strength"));
		size=Double.parseDouble(props.getProperty("size"));
		damage=Double.parseDouble(props.getProperty("damage"));
		kill=Double.parseDouble(props.getProperty("kill"));
		range=Integer.parseInt(props.getProperty("range"));
		Point2D buyStart = new Point2D(0, maxValueBuy);
		Point2D buyEnd = new Point2D(marketSaturationForBuying, minValueBuy);
		Point2D sellStart = new Point2D(0, maxValueSell);
		Point2D sellEnd = new Point2D(marketSaturationForSelling, minValueSell);
		int buyCp1X = Integer.parseInt(props.getProperty("buy.cp1.x"));
		int buyCp1Y = Integer.parseInt(props.getProperty("buy.cp1.y"));
		int buyCp2X = Integer.parseInt(props.getProperty("buy.cp2.x"));
		int buyCp2Y = Integer.parseInt(props.getProperty("buy.cp2.y"));
		int sellCp1X = Integer.parseInt(props.getProperty("sell.cp1.x"));
		int sellCp1Y = Integer.parseInt(props.getProperty("sell.cp1.y"));
		int sellCp2X = Integer.parseInt(props.getProperty("sell.cp2.x"));
		int sellCp2Y = Integer.parseInt(props.getProperty("sell.cp2.y"));
		Point2D buyCp1 = new Point2D(buyCp1X, buyCp1Y);
		Point2D buyCp2 = new Point2D(buyCp2X, buyCp2Y);
		Point2D sellCp1 = new Point2D(sellCp1X, sellCp1Y);
		Point2D sellCp2 = new Point2D(sellCp2X, sellCp2Y);
		buyCurve = new BezierPriceCurve(buyStart, buyCp1, buyCp2, buyEnd);
		sellCurve = new BezierPriceCurve(sellStart, sellCp1, sellCp2, sellEnd);
	}
}
