/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.ArrayList;
import java.util.List;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Guild
implements IGuild {
    private final ICity city;
    @ListType(value=IPlayer.class)
    private List<IPlayer> members = new ArrayList<IPlayer>();
    @ListType(value=IAuction.class)
    private List<IAuction> auctions = new ArrayList<IAuction>();

    @Override
    public void join(IPlayer player) {
        this.members.add(player);
    }

    @Override
    public void resetAuction(IAuction auction) {
        this.auctions.remove(auction);
    }

    public Guild(ICity city) {
        this.city = city;
    }

    @Override
    public ICity getCity() {
        return this.city;
    }

    @Override
    public List<IPlayer> getMembers() {
        return this.members;
    }

    @Override
    public List<IAuction> getAuctions() {
        return this.auctions;
    }
}

