/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.personal.IChild;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.IgnoreOnDeserialisation;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.service.LUIDProvider;
import ch.sahits.util.ClassChecker;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class Player
implements IPlayer {
    private String uuid;
    @ListType(value=IShip.class)
    private final ObservableList<IShip> fleet;
    @ListType(value=INavigableVessel.class)
    private final ObservableList<INavigableVessel> selectableVessel;
    private ESocialRank rank;
    private ICareer careerLevel;
    private IPersonalData personalData;
    private Optional<ISpouseData> spouse = Optional.empty();
    private final ICompany company;
    private MapSegmentedImage segmentedMap;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private LUIDProvider luidProvider;
    private int criminalDrive = 0;
    @ListType(value=IChild.class)
    private List<IChild> children;

    public Player(ICity homeTown, IPersonalData personalData, ESocialRank rank, ICompany company) {
        this.fleet = FXCollections.observableArrayList();
        this.selectableVessel = FXCollections.observableArrayList();
        this.rank = rank;
        this.careerLevel = EEconomicCareer.INEXPERIENCED;
        this.personalData = personalData;
        this.company = company;
        this.children = new ArrayList<IChild>();
    }

    @PostConstruct
    @IgnoreOnDeserialisation
    private void init() {
        this.uuid = this.luidProvider.getNextLUID();
    }

    @Override
    public String getName() {
        return this.personalData.getName();
    }

    @Override
    public String getLastName() {
        return this.personalData.getLastName();
    }

    @Override
    public ICity getHometown() {
        return this.company.getHomeTown();
    }

    @Override
    public List<IShip> getFleet() {
        return Collections.unmodifiableList(this.fleet);
    }

    @Override
    public List<INavigableVessel> getSelectableVessels() {
        return Collections.unmodifiableList(this.selectableVessel);
    }

    @Override
    public void addSelectableVessel(INavigableVessel vessel) {
        Preconditions.checkArgument((boolean)this.equals(vessel.getOwner()), (Object)"The ships owner is not this player");
        this.selectableVessel.add((Object)vessel);
    }

    @Override
    public void removeSelectableVessel(INavigableVessel vessel) {
        Preconditions.checkArgument((boolean)this.equals(vessel.getOwner()), (Object)"The ships owner is not this player");
        this.selectableVessel.remove((Object)vessel);
    }

    @Override
    public void addShip(IShip ship) {
        Preconditions.checkArgument((boolean)this.equals(ship.getOwner()), (Object)"The ships owner is not this player");
        this.fleet.add((Object)ship);
    }

    @Override
    public void removeShip(IShip ship) {
        this.fleet.remove((Object)ship);
    }

    @Override
    public List<IBuilding> findBuildings(ICity city) {
        ArrayList<IBuilding> result = new ArrayList<IBuilding>();
        for (IBuilding building : city.getBuildings()) {
            if (building.getOwner() != this) continue;
            result.add(building);
        }
        return result;
    }

    @Override
    public Optional<ITradingOffice> findTradingOffice(ICity city) {
        for (IBuilding building : city.getBuildings()) {
            if (building.getOwner() != this || !(building instanceof ITradingOffice)) continue;
            return Optional.of((ITradingOffice)building);
        }
        return Optional.empty();
    }

    @Override
    public <T extends IBuilding> List<T> findBuildings(ICity city, Class<T> buildingClass) {
        ArrayList<IBuilding> result = new ArrayList<IBuilding>();
        for (IBuilding building : city.getBuildings()) {
            ClassChecker checker = new ClassChecker(building.getClass());
            if (!checker.extendsClass(buildingClass) && !checker.implementsInterface(buildingClass) || !building.getOwner().equals(this)) continue;
            result.add(building);
        }
        return result;
    }

    @Override
    public void marry(ISpouseData spouse) {
        this.spouse = Optional.of(spouse);
    }

    @Override
    public void spouseDies() {
        this.spouse = Optional.empty();
    }

    @Override
    public IPersonalData getPersonalData() {
        return this.personalData;
    }

    @Override
    public Optional<ISpouseData> getSpouseData() {
        return this.spouse;
    }

    @Override
    public void updateRank(ESocialRank rank) {
        this.rank = rank;
    }

    @Override
    public List<INavigableVessel> findShips(ICity city) {
        return this.fleet.parallelStream().filter(ship -> ship.getLocation().equals((Object)city.getCoordinates())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Player player = (Player)o;
        return this.uuid.equals(player.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public void receiveSum(long amount) {
        if (this instanceof IHumanPlayer) {
            this.getCompany().updateCash(amount);
        } else {
            this.getCompany().updateCashDirectly(amount);
        }
    }

    @Override
    public void updateCrimialDrive(int value) {
        this.criminalDrive += value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.uuid + ") " + this.getName() + " " + this.getLastName();
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public ESocialRank getRank() {
        return this.rank;
    }

    @Override
    public ICareer getCareerLevel() {
        return this.careerLevel;
    }

    @Override
    public void setCareerLevel(ICareer careerLevel) {
        this.careerLevel = careerLevel;
    }

    @Override
    public ICompany getCompany() {
        return this.company;
    }

    @Override
    public MapSegmentedImage getSegmentedMap() {
        return this.segmentedMap;
    }

    @Override
    public void setSegmentedMap(MapSegmentedImage segmentedMap) {
        this.segmentedMap = segmentedMap;
    }

    @Override
    public int getCriminalDrive() {
        return this.criminalDrive;
    }

    @Override
    public List<IChild> getChildren() {
        return this.children;
    }
}

