/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.PersonLeavesTavernEvent;
import ch.sahits.game.openpatrician.model.people.ITavernPerson;
import ch.sahits.game.openpatrician.model.people.TavernProperties;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Random;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class BaseTavernPerson
implements ITavernPerson {
    private LocalDateTime arrivalDate;
    private BooleanProperty isPresent = new SimpleBooleanProperty((Object)this, "isPresent", false);
    @Autowired
    protected Date date;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    private ICity city;
    @Autowired
    private Random rnd;
    @Autowired
    private TavernProperties tavernProperties;

    @PostConstruct
    private void initArival() {
        this.arrivalDate = this.date.getStartDate().minusDays(this.rnd.nextInt(3));
    }

    @Override
    public boolean isPresent() {
        return this.isPresent.get();
    }

    @Override
    public BooleanProperty isPresentProperty() {
        return this.isPresent;
    }

    @Override
    public final void arrive() {
        this.arrivalDate = this.date.getCurrentDate();
        this.isPresent.set(true);
    }

    @Override
    public final void leave() {
        Preconditions.checkNotNull((Object)this.city);
        this.isPresent.set(false);
        this.clientServerEventBus.post((Object)new PersonLeavesTavernEvent(this.city, this));
    }

    @Override
    public int getNumberOfDaysSinceArrival() {
        LocalDateTime now = this.date.getCurrentDate();
        Duration duration = Duration.between(this.arrivalDate, now);
        return (int)duration.toDays();
    }

    @Override
    public int getMaxDaysAbsent() {
        return this.tavernProperties.getPerson().getMaxAbsence();
    }

    @Override
    public int getMaxDaysPresent() {
        return this.tavernProperties.getPerson().getMaxPresence();
    }

    @Override
    public LocalDateTime getArrivalDate() {
        return this.arrivalDate;
    }

    @Override
    public void setCity(ICity city) {
        this.city = city;
    }
}

