/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.Duration;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class CaptainTownMapping {
    private final ICity town;
    private final LocalDateTime arrivalDate;
    private final ICaptain captain;

    public int getNumbersOfDaysInTown(Date currentDate) {
        LocalDateTime now = currentDate.getCurrentDate();
        Duration duration = Duration.between(this.arrivalDate, now);
        return (int)duration.toDays();
    }

    public CaptainTownMapping(ICity town, LocalDateTime arrivalDate, ICaptain captain) {
        this.town = town;
        this.arrivalDate = arrivalDate;
        this.captain = captain;
    }

    public ICity getTown() {
        return this.town;
    }

    public LocalDateTime getArrivalDate() {
        return this.arrivalDate;
    }

    public ICaptain getCaptain() {
        return this.captain;
    }
}

