/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.service;

import ch.sahits.game.openpatrician.model.IModelTranslationService;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ModelTranslations
implements IModelTranslationService {
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messages;

    public String getLocalDisplayName(EWeapon weapon) {
        return this.messages.getMessage(weapon.name(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayName(IWare ware) {
        return this.messages.getMessage(ware.getWareID(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayName(ICareer career) {
        if (career instanceof EEconomicCareer) {
            return this.messages.getMessage(((EEconomicCareer)career).name(), new Object[0], this.locale.getCurrentLocal());
        }
        if (career instanceof EMilitantCareer) {
            return this.messages.getMessage(((EMilitantCareer)career).name(), new Object[0], this.locale.getCurrentLocal());
        }
        throw new IllegalArgumentException("Unknown career implementation: " + career.getClass().getName());
    }

    public String getLocalDisplayName(ESocialRank rank) {
        return this.messages.getMessage(rank.name(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayName(EShipType type) {
        return this.messages.getMessage(type.name(), new Object[0], this.locale.getCurrentLocal());
    }

    public String getLocalDisplayNameWithArticle(EShipType type, boolean upperCaseArticle) {
        String typeName = this.getLocalDisplayName(type);
        String article = EShipType.HOLK == type || EShipType.CRAYER == type ? this.getLocalDisplayDistinctArticle(true, upperCaseArticle) : this.getLocalDisplayDistinctArticle(false, upperCaseArticle);
        return article + " " + typeName;
    }

    public String getLocalDisplayDistinctArticle(boolean male, boolean uppercase) {
        String key = "articleMale";
        if (!male) {
            key = "articleFemale";
        }
        Object article = this.messages.getMessage(key, new Object[0], this.locale.getCurrentLocal());
        if (uppercase) {
            article = ((String)article).substring(0, 1).toUpperCase() + ((String)article).substring(1);
        }
        return article;
    }

    public String toShortDate(LocalDateTime c) {
        int day = c.getDayOfMonth();
        int month = c.getMonthValue();
        String sb = String.valueOf(day) + ". " + this.messages.getMessage("month_short_" + month, new Object[0], this.locale.getCurrentLocal());
        return sb;
    }

    private LocalDateTime getEndOfWeekInternal(LocalDateTime date) {
        int cdow = date.getDayOfWeek().getValue();
        LocalDateTime lastDayOfWeek = date.plusDays(7 - cdow);
        return lastDayOfWeek;
    }

    public String getEndOfWeek(LocalDateTime date) {
        LocalDateTime lastSun = this.getEndOfWeekInternal(date);
        return this.toShortDate(lastSun);
    }

    public String toDisplayString(int day, int month, int year) {
        String sb = String.valueOf(day) + ". " + this.messages.getMessage("month_short_" + month, new Object[0], this.locale.getCurrentLocal()) + " " + year;
        return sb;
    }

    private String toDisplayStringLongFormat(int day, int month, int year) {
        String sb = String.valueOf(day) + ". " + this.messages.getMessage("month_long_" + month, new Object[0], this.locale.getCurrentLocal()) + " " + year;
        return sb;
    }

    @Override
    public String toDisplayString(LocalDateTime date) {
        int day = date.getDayOfMonth();
        int month = date.getMonthValue();
        int year = date.getYear();
        return this.toDisplayString(day, month, year);
    }

    public String toDisplayStringLongFormat(LocalDateTime date) {
        int day = date.getDayOfMonth();
        int month = date.getMonthValue();
        int year = date.getYear();
        return this.toDisplayStringLongFormat(day, month, year);
    }

    public String getStartOfWeek(LocalDateTime date) {
        LocalDateTime lastMon = this.getStartOfWeekInternal(date);
        return this.toShortDate(lastMon);
    }

    private LocalDateTime getStartOfWeekInternal(LocalDateTime date) {
        return date.minusDays(date.getDayOfWeek().getValue() - 1);
    }

    public String getLocalDisplayName(IBuilding building) {
        return this.messages.getMessage("building.type" + building.getClass().getSimpleName(), new Object[0], this.locale.getCurrentLocal());
    }
}

