/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.service.persistance.converter;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import javafx.beans.binding.ObjectBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassCategory(value={EClassCategory.STARTUP})
public class ObjectBindingsConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(ObjectBindingsConverter.class);

    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        String className = o.getClass().getName();
        hierarchicalStreamWriter.addAttribute("class-name", className);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String className = hierarchicalStreamReader.getAttribute("class-name");
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.warn("Failed to create Object binding for class {}, {}", (Object)className, (Object)e.getMessage());
            return null;
        }
    }

    public boolean canConvert(Class aClass) {
        return ObjectBinding.class.isAssignableFrom(aClass);
    }
}

