/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.geometry.Point2D;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class ConvoyList
implements Iterable<IConvoy> {
    @ListType(value=IConvoy.class)
    private List<IConvoy> convois = new ArrayList<IConvoy>();

    public boolean add(IConvoy iConvoy) {
        return this.convois.add(iConvoy);
    }

    public boolean remove(Object o) {
        return this.convois.remove(o);
    }

    public List<IConvoy> findConvoy(ICity city) {
        Point2D location = city.getCoordinates();
        ArrayList<IConvoy> inTown = new ArrayList<IConvoy>();
        for (IConvoy convoy : this.convois) {
            if (!convoy.getLocation().equals((Object)location)) continue;
            inTown.add(convoy);
        }
        return inTown;
    }

    public IConvoy findConvoyOfOrleg(IShip orleg) {
        return this.convois.parallelStream().filter(convoy -> convoy.getOrlegShip().equals(orleg)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public Iterator<IConvoy> iterator() {
        return this.convois.iterator();
    }
}

