package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * Defining the difficulty in the game
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 12, 2011
 *
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public final class Difficulty {
	
	public final static Difficulty CHANDLER = new Difficulty(EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, 30000, 2, "chandler");
	public final static Difficulty MERCHANT = new Difficulty(EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, 10000, 2, "merchant");
	public final static Difficulty TRADESMAN = new Difficulty(EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, 10000, 1, "tradesman");
	public final static Difficulty COUNSILMAN = new Difficulty(EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.HARD, EDifficultyLevel.HARD, 1000, 1, "counsilman");
	public final static Difficulty PATRICIAN= new Difficulty(EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, 1000, 1, "patrician");
	/**
	 * Create the difficulty from an index, where 0 is equivalent to Chandler.
	 * @param selectedIndex index of the selection
	 * @return Difficulty matching the selection
	 */
	public static Difficulty fromIndex(int selectedIndex) {
		switch (selectedIndex) {
		case 0:
			return CHANDLER;
		case 1:
			return MERCHANT;
		case 2:
			return TRADESMAN;
		case 3:
			return COUNSILMAN;
		case 4:
			return PATRICIAN;

		default:
			throw new IndexOutOfBoundsException("No matching difficulty for index "+selectedIndex);
		}
	}
	/** 
	 * Difficulty trade: at higher settings the buying prices are 
	 * higher and the selling prices, thus reducing the margin of profit 
	 */
    @Getter
	private final EDifficultyLevel trade;
	/** Difficulty approval: at higher settings for every action that increases
	 * the approval rating a malus is taken into account. The approval rating thus
	 * rises more slowly.
	 */
    @Getter
	private final EDifficultyLevel approval;
	/**
	 * Need of civilians: at higher levels the citicens are more easily unhappy when certain
	 * wares are missing.
	 */
    @Getter
	private final EDifficultyLevel need;
	/**
	 * Naval battle strength: at higher levels the opponents navigate more intelligent.
	 */
    @Getter
	private final EDifficultyLevel navalBattle;
	/**
	 * Pirate activity: at higher levels there are more pirates that are more havily armed.
	 */
    @Getter
	private final EDifficultyLevel pirateActivity;
	/**
	 * Activity of the sovereign: at higher levels the sovereign uses larger armies and sieges do
	 * happen more often.
	 */
    @Getter
	private final EDifficultyLevel sovereignActivity;
	/**
	 * starting capital
	 */
    @Getter
	private final int startingCapital;
	/**
	 * Number of starting ships
	 */
    @Getter
	private final int numberOfShips;
	/**
	 * Name of the difficulty level.
	 */
	@Getter
	private final String level;

	public Difficulty(EDifficultyLevel trade, EDifficultyLevel approval,
			EDifficultyLevel need, EDifficultyLevel navalBattle,
			EDifficultyLevel pirateActivity,
			EDifficultyLevel sovereignActivity, int startingCapital,
			int numberOfShips, String name) {
		super();
		this.trade = trade;
		this.approval = approval;
		this.need = need;
		this.navalBattle = navalBattle;
		this.pirateActivity = pirateActivity;
		this.sovereignActivity = sovereignActivity;
		this.startingCapital = startingCapital;
		this.numberOfShips = numberOfShips;
		this.level = name;
	}
	
}
