package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * Message that can be displayed on screen. The message contents is formatted with markup.
 * A short message is displayed as a notification. The message will be displayed in the notice
 * board.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 18, 2013
 *
 */
@Getter
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class DisplayMessage implements IDisplayableMessage, IEventMetaDataProvider {
	private final EMessageCategory category;
	private final String messageKey;
	private final Object[] messageArguments;
	private String className;
	private String methodName;


	public DisplayMessage(EMessageCategory category, String messageKey, Object...messageArgs) {
		super();
		this.category = category;
		this.messageKey = messageKey;
		messageArguments = messageArgs;
		StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
		methodName = creatingStackFrame.getMethodName();
		className = creatingStackFrame.getClassName();
	}
}
