package ch.sahits.game.openpatrician.model.building;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 22, 2018
 */
@Component
@PropertySource("classpath:application.properties")
@ConfigurationProperties(prefix = "building")
@Getter
@Setter
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class BuildingProperties {

    private TradingOffice tradingOffice;

    @Getter
    @Setter
    public static class TradingOffice {
        private int capacity;
        private int storageRentPerDay;
        private int guardCostPerDay;
    }
}
