package ch.sahits.game.openpatrician.model.cheat;

import ch.sahits.game.openpatrician.model.GenericTriple;

import java.util.List;

/**
 * Define a cheat command that takes an additional argument that is selected
 * from a list of values
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 04, 2018
 */
public interface ISingleSelectableCheatCommand extends ICheatCommand{
    /**
     * List of options to be displayed.
     * @return
     */
    List<GenericTriple<String>> getOptions();

    /**
     * Set the option that was chosen.
     * @param option that was chosen.
     */
    void setSelectedOption(GenericTriple<String> option);
}
