package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.initialisation.MapInitializedBean;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * This is a map of the production stores for all city owned workshops.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on May 14, 2016
 */
@Service
@Lazy
@DependentInitialisation(MapInitializedBean.class)
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class CityProductionStorage {
    @MapType(key = ICity.class, value = ProductionStorage.class)
    private Map<ICity, ProductionStorage> storage = new HashMap<>();
    @Autowired
    private IMap map;

    @Autowired
    @XStreamOmitField
    private ApplicationContext context;

    @PostConstruct
    private void init() {
        for (ICity city : map.getCities()) {
            add(city);
        }
    }

    /**
     * Create the production storage for an additional city.
     * @param city for which to add a production storage
     */
    public void add(ICity city) {
        storage.put(city, context.getBean(ProductionStorage.class));
    }

    /**
     * Retrieve the {@link ProductionStorage} for the city.
     * @param city for which to retrieve the production storage
     * @return production storage for the city.
     */
    public ProductionStorage getStorage(ICity city) {
        return storage.get(city);
    }
}
