package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;

import java.time.LocalDateTime;

/**
 * Notice on the board in the city hall for delivering wares to other cities fo a fixed price.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ICityHallNotice {
    /**
     * Whom to contact in the destination city for delivery.
     * @return contract broker to contact
     */
    IContractBroker getContact();

    /**
     * What ware is required.
     * @return ware that is required
     */
    IWare getRequiredWare();

    /**
     * Destination to deliver the ware to.
     * @return city where the ware is required
     */
    ICity getDestination();

    /**
     * Required amount and their guaranteed price.
     * @return amount and price for the ware.
     */
    AmountablePrice<IWare> getWareAndAmount();

    /**
     * Time untill when the ware has to be delivered.
     * @return deadline until when the ware needs to be supplied.
     */
    LocalDateTime getDueDate();

}
