package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.IAcceptedAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 06, 2015
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class AcceptedAldermanTask implements IAcceptedAldermanTask {
    @Getter
    private final IAldermanTask task;
    @Getter
    private final LocalDateTime deadline;
    @Getter
    private final IPlayer player;

    public AcceptedAldermanTask(IAldermanTask task, LocalDateTime deadline, IPlayer player) {
        this.task = task;
        this.deadline = deadline;
        this.player = player;
    }
}
