package ch.sahits.game.openpatrician.model.city.guild;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

/**
 * List holding a reference to all guilds.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 06, 2016
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class GuildList implements Iterable<IGuild> {
    @ListType(IGuild.class)
    private List<IGuild> guilds = new ArrayList<>();

    @Override
    public Iterator<IGuild> iterator() {
        return guilds.iterator();
    }

    public int size() {
        return guilds.size();
    }

    public boolean isEmpty() {
        return guilds.isEmpty();
    }

    public IGuild get(int index) {
        return guilds.get(index);
    }

    public boolean add(IGuild guild) {
        return guilds.add(guild);
    }

    public Optional<IGuild> findGuild(ICity city) {
        for (IGuild guild : guilds) {
            if (guild.getCity().equals(city)) {
                return Optional.of(guild);
            }
        }
        return Optional.empty();
    }
}
