package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Value;

/**
 * Event object for a finished building.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 23, 2014
 */
@Value
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class BuildingFinished implements IEventMetaDataProvider {
    private final IBuilding building;
    private final IPlayer owner;
    private final ICity city;
    private String className;
    private String methodName;

    public BuildingFinished(IBuilding building, IPlayer owner, ICity city) {
        this.building = building;
        this.owner = owner;
        this.city = city;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
