package ch.sahits.game.openpatrician.model.people;


import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;

public interface IContractBroker extends ITradePerson {
	/**
	 * Get the name of the contract broker.
	 * @return name of the contract broker.
	 */
	String getName();

    /**
     * Retrieve the amount and price that was agreed upon.
     * @return amount and price of the ware.
     */
    AmountablePrice<IWare> getAmountAndPrice();

    /**
     * The ware that should be delivered.
     * @return ware to be delivered
     */
    IWare getWare();

    /**
     * Retrieve the amount that was already delivered.
     * @return delivered amount of hte ware.
     */
    int getDeliveredAmount();

    /**
     * Deliver a specified amount.
     * @param amount deliver the amount of ware.
     */
    void deliver(int amount);

    /**
     * Set the name of hte contract broker.
     * @param name of the contract broker.
     */
    void setName(String name);
}
