package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;

import java.util.Optional;

/**
 * Accessting the contract broker for a specific player in a city.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Apr 30, 2018
 */
public interface IContractBrokers {

    void add(IContractBroker broker, ICity city);

    /**
     * Retrieve the contract broker in the city, who is waiting for a delivery by the player.
     * @param city for which to look up the contract broker.
     * @param player from whom the broker awaits d deliver.
     * @return optional of the broker, if one is found, empty otherwise.
     */
    Optional<IContractBroker> findContractBroker(ICity city, IPlayer player);

    /**
     * Check if there is a contract broker defined for the city. It does not matter, if the broker has an assigned
     * player or not.
     * @param city for which to check the contract broker
     * @return true if there is a contract broker defined for the city.
     */
    boolean hasContractBroker(ICity city);
}
