package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.city.ICity;

import java.time.LocalDateTime;


public interface IEscorte extends ISideRoomPerson {

	/**
	 * Get the destination city for the traveler.
	 * @return destination city for the escort
	 */
	ICity getDestination();
	/**
	 * Retrieve the premium promised upon delivery.
	 * @return premium for hte completed escort.
	 */
	int getPremium();
	/**
	 * Date at which the traveler must arrive at the destination.
	 * @return
	 */
	LocalDateTime getArrivalAtDestinationDate();
}
