package ch.sahits.game.openpatrician.model.people;


/**
 * Interface defining a pirate sitting in the tavern.
 * This pirate is a constant guest. A pirate is not
 * a person as an entity but the institution sitting in
 * the tavern. The same instance can change over time.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 21, 2013
 *
 */
public interface IPirate extends ITavernPerson {
	/**
	 * Retrieve the number of followers of this pirate.
	 * @return number of followers.
	 */
	int getFollowers();
	/**
	 * Get the offered share on the profit.
	 * @return value between [0.35..0.65]
	 */
	double getProfitShare();
	/**
	 * Get the name of the pirate.
	 * @return name of the pirate
	 */
	String getName();

	/**
	 * Get the last name of the pirate.
	 * @return
	 */
	String getLastName();

	/**
	 * Set the number of followers
	 * @param followers number following the pirate
	 */
	void setFollowers(int followers);

	/**
	 * Set the name of the pirate
	 * @param name of the pirate
	 */
	void setName(String name);

	/**
	 * Set the last name of the pirate
	 * @param lastname of the pirate
	 */
	void setLastName(String lastname);

	/**
	 * Set the profite share
	 * @param profitShare share of the profit to be transferred to the player.
	 */
	void setProfitShare(double profitShare);
}
