package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.map.IMapSection;

/**
 * Task to hunt down a priate based on a {@link IMapSection}.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface IPirateHunter extends ISideRoomPerson {
	/**
	 * Name of the client
	 * @return name of the citizen issueing the request
	 */
	String getClientName();
	/**
	 * Retrieve the name of the client.
	 * @return name of the pirate
	 */
	String getPirateName();
	/**
	 * Retrieve the promissed premium.
	 * @return premium when the pirate is defeated.
	 */
	int getPremium();

	/**
	 * Set the name of the client
	 * @param clientName name of the requester
	 */
	void setClientName(String clientName);

	/**
	 * Set the name of the pirate
	 * @param pirateName name of hte pirate
	 */
	void setPirateName(String pirateName);

	/**
	 * Set the premium
	 * @param premium to be paid after completion.
	 */
	void setPremium(int premium);
}
