package ch.sahits.game.openpatrician.model.people;
/**
 * Trader who looks to store goods in another warehouse.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface IWarehouseTenant extends ISideRoomPerson {
	/**
	 * Retrieve the name of the trader.
	 * @return of the warehouse tenant
	 */
	String getName();
	/**
	 * Retrieve the amount to be stored in bales.
	 * @return amount required to store in bales.
	 */
	int getAmount();
	/**
	 * Retrieve the sum that will be payed per week.
	 * @return weekly rent
	 */
	int getRentPerWeek();

	/**
	 * Set the tenents name
	 * @param name of the warehouse tenant
	 */
	void setName(String name);

	/**
	 * Set the required amount of space to be rented
	 * @param amount of space in bales.
	 */
	void setAmount(int amount);
}
