package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.AUpdatable;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * Implementation of a buyer. Every city can have a buyer and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatable
public class BuyerState extends BaseTavernPerson implements IBuyer {
	@Getter
	@Setter
	private String name;
	@Setter
	private LocalDateTime deadline;
	@Getter
	@Setter
	private IWare ware;
	@Setter
	@Getter
	private AmountablePrice<IWare> amountablePrice;

	public BuyerState() {
	}

	public BuyerState(IBuyer buyer) {
		this.name = buyer.getName();
		this.deadline = buyer.getTimeFrame();
		this.ware = buyer.getWare();
		this.amountablePrice = buyer.getAmountablePrice();
	}

	@Override
	public LocalDateTime getTimeFrame() {
		return deadline;
	}
}

