package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 22, 2018
 */
@Component
@PropertySource("classpath:application.properties")
@ConfigurationProperties(prefix = "aiplayer")
@Getter
@Setter
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AIPlayerProperties {
    private int lowMoney;
    private int loanPaybackLimit;
}
