package ch.sahits.game.openpatrician.model.service.persistance.converter;

import ch.sahits.game.openpatrician.model.city.impl.Contribution;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 01, 2015
 */
@ClassCategory(EClassCategory.STARTUP)
public class ContributionConverter implements Converter {
    @Override
    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Contribution contribution = (Contribution) o;
        hierarchicalStreamWriter.addAttribute("ware", contribution.getWare().name());
        hierarchicalStreamWriter.addAttribute("timestamp", contribution.getTimestamp().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        hierarchicalStreamWriter.addAttribute("amount", String.valueOf(contribution.getAmount()));
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        EWare ware = EWare.valueOf(hierarchicalStreamReader.getAttribute("ware"));
        LocalDateTime timestamp = LocalDateTime.parse(hierarchicalStreamReader.getAttribute("timestamp"));
        int amount = Integer.parseInt(hierarchicalStreamReader.getAttribute("amount"));
        return new Contribution(timestamp, amount, ware);
    }

    @Override
    public boolean canConvert(Class aClass) {
        return Contribution.class.equals(aClass);
    }
}
