package ch.sahits.game.openpatrician.model.service.persistance.converter;

import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 01, 2015
 */
@ClassCategory(EClassCategory.STARTUP)
public class WareConverter implements Converter {
    @Override
    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        hierarchicalStreamWriter.addAttribute("ware", ((EWare)o).name());
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        return EWare.valueOf(hierarchicalStreamReader.getAttribute("ware"));
    }

    @Override
    public boolean canConvert(Class aClass) {
        return EWare.class.equals(aClass);
    }
}
