package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import javafx.geometry.Point2D;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * List of all convois.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Feb 07, 2016
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class ConvoyList implements Iterable<IConvoy> {
    @ListType(IConvoy.class)
    private List<IConvoy> convois = new ArrayList<>();

    public boolean add(IConvoy iConvoy) {
        return convois.add(iConvoy);
    }

    public boolean remove(Object o) {
        return convois.remove(o);
    }

    /**
     * Find all convois in town.
     * @param city for which to find convoys
     * @return list ov convoys in the city.
     */
    public List<IConvoy> findConvoy(ICity city) {
        Point2D location = city.getCoordinates();
        ArrayList<IConvoy> inTown = new ArrayList<>();
        for (IConvoy convoy : convois) {
            if (convoy.getLocation().equals(location)) {
                inTown.add(convoy);
            }
        }
        return inTown;
    }


    /**
     * Find the convoy of an <code>orleg</code> ship.
     * @param orleg of the convoy that is looked up.
     * @return convoy
     * @throws IllegalArgumentException when the <code>orleg</code> is not an orleg ship of any convoy.
     */
    public IConvoy findConvoyOfOrleg(IShip orleg) {
        return convois.parallelStream()
                .filter(convoy -> convoy.getOrlegShip().equals(orleg))
                .findFirst()
                .orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public Iterator<IConvoy> iterator() {
        return convois.iterator();
    }
}
