package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import javafx.geometry.Point2D;

import java.util.Optional;

/**
 * One slot for a weapon
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Aug 15, 2017
 */
public interface IWeaponSlot {
    /**
     * Retrieve the side the slot is located on.
     * @return side of the slot.
     */
    ESide getSide();

    /**
     * Retrieve the weapon stored in this slot.
     * @return Optional weapon. Empty when the slot is free
     */
    Optional<IWeapon> getWeapon();

    /**
     * Set or unset a weapon in the slot. <code>null</code> will unset the weapon.
     * @param weapon to place in the the slot
     */
    void setWeapon(IWeapon weapon);

    /**
     * Retrieve the offset of the empty weapon slot.
     * @return offset of the slot
     */
    Point2D getOffset();

    /**
     * Retrieve the identifier for this slot.
     * @return ID of the slot.
     */
    int getId();
}
