package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.map.IMap;
import javafx.beans.property.ObjectProperty;

/**
 * Model of the game.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 9, 2011
 *
 */
public interface IGame {
	/**
	 * Retrieve the map
	 * @return reference to the game map
	 */
	IMap getMap();
	/**
	 * check if the objective of the game is reached. This method may not be called by the server part
	 * @return flag indicating of the game objective has been reached
	 */
	boolean isObjectivReached();
	/**
	 * Set a new game speed
	 * @param speed new game speed.
	 */
	void setGameSpeed(EGameSpeed speed);
	/**
	 * Retrieve the current game speed
	 * @return current game speed
	 */
	EGameSpeed getGameSpeed();

	/**
	 * Property for the game speed.
	 * @return property of the current game speed.
     */
	ObjectProperty<EGameSpeed> gameSpeedProperty();
	/**
	 * Retrieve the difficultiy level of the game
	 * @return difficulty level
	 */
	Difficulty getDifficulty();

	/**
	 * Switch to fast forward until the first interuption.
	 */
	void fastForward();

	/**
	 * Return to normal speed.
	 */
	void normalSpeed();
}
