package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import lombok.Getter;
import lombok.Setter;

/**
 * Store configuration of the messages.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Aug 05, 2018
 */
@Getter
@Setter
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class MessageConfiguration {
    private int retainedTradeMessages = 50;
    private int retainedPersonalMessages = 50;
    private int retainedOfficialMessages = 50;
}
