package ch.sahits.game.openpatrician.model.building;
/**
 * Interface defining the steward
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 20, 2012
 *
 */
public interface ISteward {
	/**
	 * Retrieve the level of expertise of the steward
	 * @return level of expertise
	 */
	int getExpertiseLevel();

	/**
	 * Increase the experiance level by one. The highest level i 5.
	 */
	void upgradeToNextLevel();
	/**
	 * Retrieve the weekly salary of the steward
	 * @return current sallery per week.
	 */
	int getSalary();

	/**
	 * Retrieve the amount of profit the steward made. The profit
	 * defines when the next level is reached.
	 * @return total profit.
	 */
	int getTotalProfit();

	/**
	 * Add the profit the total profit.
	 * @param profit additional profit to the total (may be negative)
	 */
	void updateProfit(int profit);
}
