package ch.sahits.game.openpatrician.model.cheat;

import javafx.scene.input.KeyCode;

/**
 * Interface for a cheat command.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 04, 2018
 */
public interface ICheatCommand {
    /**
     * Retrieve the control key that goes with the cheat command.
     * @return control key (like Ctrl, Shift, Alt)
     */
    KeyCode getControlKey();

    /**
     * Retrieve the key that will activate this cheat together with the control key.
      * @return cheat key
     */
    KeyCode getKey();

    /**
     * Retrieve the text key for describing the cheat.
     * @return text key.
     */
    String getDescriptionTextKey();

    /**
     * Execute this cheat.
     */
    void execute();
}
