package ch.sahits.game.openpatrician.model.cheat;

import ch.sahits.game.openpatrician.model.GenericTriple;

import java.util.List;

/**
 * Cheat command taking two additional parameters.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 04, 2018
 */
public interface IDoubleSelectableCheatCommand extends ICheatCommand {
    /**
     * List of first options to be displayed.
     * @return
     */
    List<GenericTriple<String>> getFirstOptions();
    /**
     * List of second options to be displayed.
     * @return
     */
    List<GenericTriple<String>> getSecondOptions();

    /**
     * Set the first option that was chosen.
     * @param option that was chosen.
     */
    void setSelectedFirstOption(GenericTriple<String> option);

    /**
     * Set the first option that was chosen.
     * @param option that was chosen.
     */
    void setSelectedSecondOption(GenericTriple<String> option);

    /**
     * Hook to update the model at the time it is used to display the options.
      */
    void setupModel();
}
