package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.product.IWare;

/**
 * Defineing the needed interface for the production in buildings.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on May 15, 2016
 */
public interface IBuildingProduction {
    /**
     * Compute the total amount of ware that is produced in the city within a week
     * @param ware that is produced
     * @param city in witch the ware is produced
     * @return total amount of all the production by all the players in the city
     */
    int getTotalProduction(IWare ware, ICity city);
    /**
     * Retrieve the amount the workshops consume to produce the ware within a week
     * @param ware that is consumed
     * @param city in witch the ware is consumed
     * @return amount of the ware that is consumed
     */
    int getTotalConsumtion(IWare ware, ICity city);
    /**
     * Compute the total amount of ware the player produces in the city within a week
     * @param ware that is produced
     * @param city in witch the ware is produced
     * @param player that produces the ware
     * @return total amount of the ware produced by that player in the city
     */
    int getProduction(IWare ware,ICity city, IPlayer player);
}
